#############################################################################
#############################################################################
#
# latexSmart.tcl (called from latex.tcl)
#
# Smart quotes, dots, subscripts, and superscripts
#
#############################################################################
#
# Original author unknown, then Tom Scavo and now:
#
# Maintainer:  Vince Darley <vince@santafe.edu>
#
#############################################################################
#############################################################################

proc latexSmart.tcl {} {}

#--------------------------------------------------------------------------
# Smart quotes:
#--------------------------------------------------------------------------

proc smartDQuote {} {
    global TeXmodeVars
    if { !$TeXmodeVars(smartQuotes) || [literalChar] } { typeText {"}; return }
    if {[leftQ]} {
	typeText {``}
    } else {
	typeText {''}
    }
}

proc smartQuote {} {
    global TeXmodeVars
    if { !$TeXmodeVars(smartQuotes) || [literalChar]  } { typeText {'}; return }
    if {[leftQ]} {
	typeText {`}
    } else {
	typeText {'}
    }
}

proc leftQ {} {
    if {[getPos] == [minPos]} { return 1 };
    return [regexp "\[\[ \t\r\n\(\{<\]" [lookAt [pos::math [getPos] - 1]]]
}

#--------------------------------------------------------------------------
# Smart dots:
#--------------------------------------------------------------------------

proc smartDots {} {
    global TeXmodeVars
    if {[isSelection]} { deleteSelection }
    if { !$TeXmodeVars(smartDots) || [literalChar] } { insertText {.}; return }
    if {[lookAt [pos::math [set endPos [getPos]] - 1]] == "."} {
	if {[lookAt [set begPos [pos::math $endPos - 2]]] == "."} {
	    replaceText $begPos $endPos "\\ldots"
	} else {
	    insertText "."
	}
    } else {
	insertText "."
    }
}

#--------------------------------------------------------------------------
# Smart subscripts and superscripts:
#--------------------------------------------------------------------------

proc smartSubscripts {} {
    smartScripts {_}
}

proc smartSuperscripts {} {
    smartScripts {^}
}

proc smartScripts {char} {
    if {[isSelection]} { deleteSelection }
    if {[literalChar]} {
	insertText $char
	return
    }
    # Filenames contain literal underscores:
    set pat {\\(usepackage|input|include(only)?|documentclass|bibliography(style)?|LoadClass|RequirePackage|begin\{filecontents\})(\[[^][]*\])?\{}
    if { [findPatJustBefore "$pat" "${pat}\[.:a-zA-Z0-9/^_-\]*\$"] != "" } {
	insertText $char
	return
    }
    if { $char == {_} } { subscript } { superscript }
}

#--------------------------------------------------------------------------
# Escapes and exceptions:
#--------------------------------------------------------------------------
lappend TeX::smartEscape {0 ''$ {"}} {0 ``$ {"}} {0 `$ {'}} {0 \\\\ldots$ {...}} \
  {2 _\{\}\$ {_}} {2 \\^\{\}\$ {^}} {1 label\{eq:\}$ {nonumber}}

proc escapeSmartStuff {} {
    global TeXmodeVars
    if {![isSelection]} {
	set pos [getPos]
	set text [getText [lineStart $pos] $pos]
	global TeX::smartEscape
	foreach i [set TeX::smartEscape] {
	    set off [lindex $i 0]
	    set look [lindex $i 1]
	    if {!$TeXmodeVars(smartQuotes) \
	      && [regexp {['"`]} [string index $look 0]]} {
		continue
	    }
	    if {$off == 0} {
		if {[regexp -- $look $text got]} {
		    replaceText [pos::math $pos - [string length $got]] $pos [lindex $i 2]
		    return
		}
	    } else {
		if {[pos::compare [set end [pos::math $pos + $off]] <= [maxPos]]} {
		    if {[regexp -- $look [getText [lineStart $pos] $end] got]} {
			set pos $end
			replaceText [pos::math $pos - [string length $got]] $pos [lindex $i 2]
			return
		    }
		}
	    }
	    
	}
    }
    backSpace
}

